******************************************
* This Stata do-file is prepared to accompany the paper
* A.B. Atkinson & A. Leigh, "The Distribution of Top Incomes in Five Anglo-Saxon Countries Over the Long-Run"
* Economic Record, 2013
* In what follows, the figure and table numbering refers to the long version, available as IZA Discussion Paper 4937. 
* Some tables are omitted from the published version.
* Feel free to use or adapt these data, so long as you cite our paper.
* Questions to andrew_leigh@ksg02.harvard.edu
******************************************

version 10

clear
set more off
cd "C:\Users\Andrew\Top Incomes\Regressions\"
use topincomes_sharedata_nov07.dta, clear
merge taxyear using topincomes_taxdata_nov07.dta
drop _merge
tsset taxyear
for var aus* ca* nz* uk* us*: gen lag5=1 if X==. & l.X==. & l2.X==. & l3.X==. & l4.X==. \ replace lag5=1 if f.lag5==1 | f2.lag5==1 | f3.lag5==1 | f4.lag5==1 \ ipolate X taxyear if lag5~=1, gen(temp) \ replace X=temp \ drop temp lag
for any aus ca nz us: gen Xnext4=X5-X1
gen uk5=uknext4+uk1
save topincomes.dta, replace

*********************************************************************
* Graphs
*********************************************************************
clear
set more off
cd "C:\Users\Andrew\Top Incomes\Regressions\"
use topincomes.dta, clear
for any aus ca nz uk us \ any Australia Canada "New Zealand" "United Kingdom" "United States": la var X01 "Y" \ la var X1 "Y" \ la var Xnext4 "Y" \ la var X5 "Y"
for any aus ca nz uk us: egen X_01mean=mean(X01) if taxyear>=1921 & taxyear<=2000 \ egen X_1mean=mean(X1) if taxyear>=1921 & taxyear<=2000 \ egen X_next4mean=mean(Xnext4) if taxyear>=1921 & taxyear<=2000 
tabstat *_01mean *_1mean *_next4mean, col(stat) 
drop *mean
set scheme s1mono
tw connected aus01 ca01 nz01 uk01 us01 taxyear if taxyear>=1920, msize(medsmall medsmall medsmall medsmall medsmall) lpattern(solid solid solid solid solid) xti("") yti("Share %") ti("Figure 1: Share of Top 0.1%") legend(colfirst)
tw connected aus1 ca1 nz1 uk1 us1 taxyear if taxyear>=1920, msize(medsmall medsmall medsmall medsmall medsmall) lpattern(solid solid solid solid solid) xti("") yti("Share %") ti("Figure 2: Share of Top 1%") legend(colfirst)
tw connected ausnext4 canext4 nznext4 uknext4 usnext4 taxyear if taxyear>=1920, msize(medsmall medsmall medsmall medsmall medsmall) lpattern(solid solid solid solid solid) xti("") yti("Share %") ti("Figure 3: Share of 'Next' 4%") legend(colfirst)

egen mean01=rowmean(aus01 ca01 nz01 uk01 us01)
for any aus ca nz uk us: gen Xdiff01=X01-mean01
gen cv01=((aus01^2+ca01^2+nz01^2+uk01^2+us01^2)/(5*mean01^2)-1)^.5
for any aus ca nz uk us \ any Australia Canada "New Zealand" "United Kingdom" "United States": la var Xdiff01 "Y"
la var cv01 "Coefficient of Variation"
#delimit ;
tw connected ausdiff01 cadiff01 nzdiff01 ukdiff01 usdiff01 taxyear if taxyear>=1921 & taxyear<=2000, yaxis(1) 
msize(medsmall medsmall medsmall medsmall medsmall) lpattern(solid solid solid solid solid) || 
line cv01 taxyear if taxyear>=1921 & taxyear<=2000, lcolor(black) lwidth(medthick) lpattern(solid) yaxis(2) xti("") yti("Difference from Mean Share of Top 0.1%",axis(1)) 
yti("Coefficient of Variation", axis(2)) ti("Figure 5: Cross-Country Variation in the" "Top 0.1% Share") legend(colfirst);
#delimit cr
list taxyear cv01

for any aus ca nz uk us: gen Xss=X01/X1 \ gen Xpl=1/(1-ln(X01/X1)/ln(.1))
for any aus ca nz uk us \ any Australia Canada "New Zealand" "United Kingdom" "United States": la var Xss "Y" \ la var Xpl "Y"
#delimit ;
tw connected ausss cass nzss ukss usss taxyear if taxyear>=1920, 
msize(medsmall medsmall medsmall medsmall medsmall) lpattern(solid solid solid solid solid)
yti("") xti("") ti("Figure 6: Share of Top 0.1% Within Top 1%") legend(colfirst);
#delimit cr
#delimit ;
tw connected auspl capl nzpl ukpl uspl taxyear if taxyear>=1920, 
msize(medsmall medsmall medsmall medsmall medsmall) lpattern(solid solid solid solid solid)
yti("") xti("") ti("Figure 7: Pareto-Lorenz Coefficients S0.1/S1") legend(colfirst);
#delimit cr
list taxy auspl capl nzpl ukpl uspl

* Precisely when are the Figure 4 numbers for?
for num 1919 1920 1921 1937 1938 1939 1949 1950 1980 1981 2000 2001: list taxyear aus5 aus1 aus01 ca5 ca1 ca01 nz5 nz1 nz01 uk5 uk1 uk01 us5 us1 us01 if taxy==X 
reshape long aus ca nz uk us,i(taxyear) j(var) str
for any aus ca nz uk us \ any Australia Canada "New Zealand" "United Kingdom" "United States": la var X "Y" 
*destring var, force replace
*label define percent 5 "5%" 1 "1%" 01 "0.1%"
*label values var percent
egen varno=group(var)
tsset varno taxyear
for var aus*: replace X=f.X if taxyear==1920 \ replace X=. if taxyear==1938 \ replace X=f.X if taxyear==1938
for var nz*: replace X=f.X if taxyear==1920 \ replace X=. if taxyear==2000 \ replace X=f.X if taxyear==2000
for var uk*: replace X=. if taxyear==1920 \ replace X=l.X if taxyear==1920 \ replace X=. if taxyear==1938 \ replace X=l.X if taxyear==1938

gen barorder=.
for any 5 1 01 \ num 1/3: replace barorder=Y if var=="X"
for num 1920 1938 1949 1980: graph bar aus ca nz uk us if taxyear==X & (var=="5" | var=="1" | var=="01"),over(var, sort(barorder) relabel(3 "5%" 2 "1%" 1 "0.1%")) yti("Share in total income") ti("X") legend(off) nodraw name(_X, replace)
for num 2000: graph bar aus ca nz uk us if taxyear==X & (var=="5" | var=="1" | var=="01"), over(var, sort(barorder) relabel(3 "5%" 2 "1%" 1 "0.1%")) yti("Share in total income") ti("X") name(_X, replace) legend(off) nodraw
graph bar aus ca nz uk us if taxyear==1900 & (var=="5" | var=="1" | var=="01"), over(var, sort(barorder) label(nolabels) axis(off)) ysca(off) ylabel(#0) yti("") ti("") name(_legend, replace) legend(pos(0) col(1) label(1 Australia) label(2 Canada) label(3 "New Zealand") label(4 "United Kingdom") label(5 "United States")) graphregion(ilstyle(none)) plotregion(style(none)) nodraw
gr combine _1920 _1938 _1949 _1980 _2000 _legend, ycommon ti("Figure 4: Shares of Top Income Groups" "in Five Anglo-Saxon Countries") 

for any 5 1 01: list taxyear aus ca nz uk us if (taxy==1920 | taxy==1938 | taxy==1949 | taxy==1980 | taxy==2000) & var=="X"
list aus ca nz uk us if taxy==1953 & var=="01"

*********************************************************************
* Correlations - cross-country
*********************************************************************
clear
set more off
set matsize 200
cd "C:\Users\Andrew\Top Incomes\Regressions\"
use topincomes.dta
tsset taxyear, yearly
*for X in any aus ca nz uk us: gen Xv2=X10-X5

* Aligning the series - putting all in calendar year format
for any 01 1 next4: gen temp=f.ausX \ replace ausX=(ausX+temp)/2 \ drop temp
for any 01 1 next4: gen temp=f.ukX \ replace ukX=ukX*.75+temp*.25 \ drop temp \ gen temp=f.nzX \ replace nzX=nzX*.75+temp*.25 \ drop temp

* Correlations - levels
for any 01 1 next4: pwcorr ausX caX nzX ukX usX, sig obs
for any 01 1 next4: corr ausX caX \ gen corrX=r(rho) \ corr ausX nzX \ replace corrX=corrX+r(rho) \ corr ausX ukX \ replace corrX=corrX+r(rho) \ corr ausX usX \ replace corrX=corrX+r(rho) \ corr caX nzX \ replace corrX=corrX+r(rho) \ corr caX ukX \ replace corrX=corrX+r(rho) \ corr caX usX \ replace corrX=corrX+r(rho) \ corr nzX ukX \ replace corrX=corrX+r(rho) \ corr nzX usX \ replace corrX=corrX+r(rho) \ corr ukX usX \ replace corrX=corrX+r(rho) \ replace corrX=corrX/10
sum corr*
drop corr*

* Correlations - first differenced
for X in any aus ca nz uk us: for Y in any 01 1 next4: gen XdY=d.XY 
for any d01 d1 dnext4: pwcorr ausX caX nzX ukX usX, sig obs
for any d01 d1 dnext4: corr ausX caX \ gen corrX=r(rho) \ corr ausX nzX \ replace corrX=corrX+r(rho) \ corr ausX ukX \ replace corrX=corrX+r(rho) \ corr ausX usX \ replace corrX=corrX+r(rho) \ corr caX nzX \ replace corrX=corrX+r(rho) \ corr caX ukX \ replace corrX=corrX+r(rho) \ corr caX usX \ replace corrX=corrX+r(rho) \ corr nzX ukX \ replace corrX=corrX+r(rho) \ corr nzX usX \ replace corrX=corrX+r(rho) \ corr ukX usX \ replace corrX=corrX+r(rho) \ replace corrX=corrX/10
sum corr*
drop corr*

*********************************************************************
* Correlations - intra-country
*********************************************************************
clear
set matsize 200
cd "C:\Users\Andrew\Top Incomes\Regressions\"
use topincomes.dta
tsset taxyear, yearly

for X in any aus ca nz uk us: for Y in any 01 1 next4: gen XdY=d.XY 
for any aus ca nz uk us: pwcorr X1 Xnext4, sig obs 
*for any aus ca nz uk us: pwcorr X1 Xnext4, sig obs \ pwcorr Xd1 Xdnext4, sig obs
for X in any d1 \ Y in any dnext4 \ A in any 1900 \ B in any 2002: corr ausX ausY if taxyear>=A & taxyear<=B \ gen corrXY=r(rho) \ corr nzX nzY  if taxyear>=A & taxyear<=B \ replace corrXY=corrXY+r(rho) \ corr caX caY  if taxyear>=A & taxyear<=B \ replace corrXY=corrXY+r(rho) \ corr usX usY  if taxyear>=A & taxyear<=B \ replace corrXY=corrXY+r(rho) \ corr ukX ukY  if taxyear>=A & taxyear<=B \ replace corrXY=corrXY/5
for X in any 1 \ Y in any next4 \ A in any 1900 \ B in any 2002: corr ausX ausY if taxyear>=A & taxyear<=B \ gen corrXY=r(rho) \ corr nzX nzY  if taxyear>=A & taxyear<=B \ replace corrXY=corrXY+r(rho) \ corr caX caY  if taxyear>=A & taxyear<=B \ replace corrXY=corrXY+r(rho) \ corr usX usY  if taxyear>=A & taxyear<=B \ replace corrXY=corrXY+r(rho) \ corr ukX ukY  if taxyear>=A & taxyear<=B \ replace corrXY=corrXY/5
sum corr*
drop corr*

*********************************************************************
* Graphs of Top income shares and tax rates
*********************************************************************

cd "C:\Users\Andrew\Top Incomes\Regressions\"
use topincomes.dta, clear
tsset taxyear, yearly
for any aus ca nz uk us: gen temp=max(X_inctax_wage, X_inctax_inv) \ gen X_tax=100-temp \ drop temp
set scheme s1mono
*for any aus ca nz uk us \ any Australia Canada "New Zealand" UK US: graph twoway line X01 taxyear || line X_tax taxyear, yaxis(2) clpattern(dash) || in 25/117, ytitle("", axis(1)) ytitle("", axis(2)) xtitle("") xlabel(1912(20)2002) title("Y") name(X, replace) legend(off) nodraw
*gr combine aus ca nz uk us, ycommon col(2) iscale(*.8) title("Figure 8: Share of the Top 0.1% (solid line, left axis)" "& 1-Top Marginal Tax Rate (dashed line, right axis)")
for any aus ca nz uk us \ any Australia Canada "New Zealand" UK US: graph twoway line X1 taxyear || line X_tax taxyear, yaxis(2) clpattern(dash) || in 25/117, ytitle("", axis(1)) ytitle("", axis(2)) xtitle("") xlabel(1912(20)2002) title("Y") name(X, replace) legend(off) nodraw
gr combine aus ca nz uk us, ycommon col(2) iscale(*.8) title("Figure 8: Share of the Top 1% (solid line, left axis)" "& 1-Top Marginal Tax Rate (dashed line, right axis)")

**************************************************************************************
* Regressions
**************************************************************************************
clear
set more off
cd "C:\Users\Andrew\Top Incomes\Regressions\"
use topincomes.dta
for any bills bonds equities: gen nz_X=.
for X in any aus ca nz uk us \ num 1/5: ren X_gdp gdpY \ ren X_inctax_wage_median inctax_wage_medianY \ ren X_inctax_inv_median inctax_inv_medianY \ ren X_inctax_wage inctax_wageY \ ren X_inctax_inv inctax_invY \ ren X1 _1Y \ ren X_equities equitiesY \ ren X_bills billsY \ ren X_bonds bondsY \ ren X_growth growthY
keep inctax_wage* inctax_inv* _1* taxyear equities* bills* bonds* growth* gdp*
drop if taxyear==.
reshape long inctax_wage_median inctax_inv_median inctax_inv inctax_wage _1 equities bills bonds growth gdp, i(taxyear) j(ctyno) 
gen str3 cty=""
for X in any aus ca nz uk us \ num 1/5: replace cty="X" if ctyno==Y
tsset ctyno taxyear, yearly
* Using previous year values for the few missing numbers
for any equities bills bonds growth: replace X=l.X if X==. 
replace gdp=l.gdp*1.02 if taxyear==2004 & (cty=="us" | cty=="aus")
for num 2004/2006: replace gdp=l.gdp*1.02 if taxyear==X & cty=="nz"
* Putting rate of return and growth variables on a taxyear basis
for any equities bills bonds growth gdp: gen temp=f.X \ replace X=(X+temp)/2 if cty=="aus" \ replace X=X*.75+temp*.25 if cty=="nz" | cty=="uk" \ drop temp 
for var equities bills bonds growth: replace X=X/100 
* Turning rates of growth in Dimson data into an index
global x equities
gen tempindex=.
for num 1900/2004: bysort ctyno: egen temp=sum($x) if taxyear<=X \ replace tempindex=temp if taxyear==X \ drop temp
replace $x=tempindex
drop tempindex
global x bills
gen tempindex=.
for num 1900/2004: bysort ctyno: egen temp=sum($x) if taxyear<=X \ replace tempindex=temp if taxyear==X \ drop temp
replace $x=tempindex
drop tempindex
global x bonds
gen tempindex=.
for num 1900/2004: bysort ctyno: egen temp=sum($x) if taxyear<=X \ replace tempindex=temp if taxyear==X \ drop temp
replace $x=tempindex
drop tempindex
global x growth
gen tempindex=.
for num 1900/2004: bysort ctyno: egen temp=sum($x) if taxyear<=X \ replace tempindex=temp if taxyear==X \ drop temp
replace $x=tempindex
drop tempindex
for var equities bills bonds growth: replace X=. if cty=="nz"
* Logging GDP
replace gdp=ln(gdp)
la var gdp "Log real GDP per capita"
* Creating after-tax share
for var inctax_wage_median inctax_inv_median inctax_inv inctax_wage: replace X=(1-(X/100)) 
* Logging top income share
replace _1=ln(_1/100)
* Creating lagged investment tax rates
for any inctax_inv inctax_inv_median: gen X_ma5=(X+l.X+l2.X+l3.X+l4.X)/5 \ gen X_ma10=(X+l.X+l2.X+l3.X+l4.X+l5.X+l6.X+l7.X+l8.X+l9.X)/10

* Wage tax regressions (Table 5)
xi: ivreg2 _1 (inctax_wage_median=inctax_wage) i.ctyno i.taxyear, cl(ctyno) fwl(_I*) first
outreg using table_results.doc, coefastr se nocons 3aster replace ct("") bdec(3) bracket
xi: ivreg2 _1 (inctax_wage_median=inctax_wage) gdp i.ctyno i.taxyear, cl(ctyno) fwl(_I*) first
outreg using table_results.doc, coefastr se nocons 3aster append ct("") bdec(3) bracket
xi: ivreg2 _1 (inctax_wage_median=inctax_wage) gdp i.ctyno i.taxyear if cty~="nz", cl(ctyno) fwl(_I*) first
outreg using table_results.doc, coefastr se nocons 3aster append ct("No NZ") bdec(3) bracket
xi: ivreg2 _1 (inctax_wage_median=inctax_wage) gdp bills bonds equities i.ctyno i.taxyear, cl(ctyno) fwl(_I*) first 
outreg using table_results.doc, coefastr se nocons 3aster append ct("") bdec(3) bracket

* Investment tax regressions with 5 year MA (Table 6, Panel A)
xi: ivreg2 _1 (inctax_inv_median_ma5=inctax_inv_ma5) i.ctyno i.taxyear, cl(ctyno) fwl(_I*) first 
outreg using table_results.doc, coefastr se nocons 3aster append ct("") bdec(3) bracket
xi: ivreg2 _1 (inctax_inv_median_ma5=inctax_inv_ma5) gdp i.ctyno i.taxyear, cl(ctyno) fwl(_I*) first 
outreg using table_results.doc, coefastr se nocons 3aster append ct("") bdec(3) bracket
xi: ivreg2 _1 (inctax_inv_median_ma5=inctax_inv_ma5) gdp i.ctyno i.taxyear if cty~="nz", cl(ctyno) fwl(_I*) first 
outreg using table_results.doc, coefastr se nocons 3aster append ct("No NZ") bdec(3) bracket
xi: ivreg2 _1 (inctax_inv_median_ma5=inctax_inv_ma5) gdp bills bonds equities i.ctyno i.taxyear, cl(ctyno) fwl(_I*) first 
outreg using table_results.doc, coefastr se nocons 3aster append ct("") bdec(3) bracket

* Investment tax regressions with 10 year MA (Table 6, Panel B)
xi: ivreg2 _1 (inctax_inv_median_ma10=inctax_inv_ma10) i.ctyno i.taxyear, cl(ctyno) fwl(_I*) first 
outreg using table_results.doc, coefastr se nocons 3aster append ct("") bdec(3) bracket
xi: ivreg2 _1 (inctax_inv_median_ma10=inctax_inv_ma10) gdp i.ctyno i.taxyear, cl(ctyno) fwl(_I*) first 
outreg using table_results.doc, coefastr se nocons 3aster append ct("") bdec(3) bracket
xi: ivreg2 _1 (inctax_inv_median_ma10=inctax_inv_ma10) gdp i.ctyno i.taxyear if cty~="nz", cl(ctyno) fwl(_I*) first 
outreg using table_results.doc, coefastr se nocons 3aster append ct("No NZ") bdec(3) bracket
xi: ivreg2 _1 (inctax_inv_median_ma10=inctax_inv_ma10) gdp bills bonds equities i.ctyno i.taxyear, cl(ctyno) fwl(_I*) first 
outreg using table_results.doc, coefastr se nocons 3aster append ct("") bdec(3) bracket

* Wage tax rate & Investment tax regressions with 5 year MA (Table 7, Panel A)
xi: ivreg2 _1 (inctax_wage_median inctax_inv_median_ma5=inctax_wage inctax_inv_ma5) i.ctyno i.taxyear, cl(ctyno) fwl(_I*) first 
lincom inctax_wage_median+inctax_inv_median_ma5
outreg using table_results.doc, coefastr se nocons 3aster append ct("") bdec(3) bracket addstat(Lincom,r(estimate),SE,r(se),T,r(estimate)/r(se)) adec(3)
xi: ivreg2 _1 (inctax_wage_median inctax_inv_median_ma5=inctax_wage inctax_inv_ma5) gdp i.ctyno i.taxyear, cl(ctyno) fwl(_I*) first 
lincom inctax_wage_median+inctax_inv_median_ma5
outreg using table_results.doc, coefastr se nocons 3aster append ct("") bdec(3) bracket addstat(Lincom,r(estimate),SE,r(se),T,r(estimate)/r(se)) adec(3)
xi: ivreg2 _1 (inctax_wage_median inctax_inv_median_ma5=inctax_wage inctax_inv_ma5) gdp i.ctyno i.taxyear if cty~="nz", cl(ctyno) fwl(_I*) first 
lincom inctax_wage_median+inctax_inv_median_ma5
outreg using table_results.doc, coefastr se nocons 3aster append ct("No NZ") bdec(3) bracket addstat(Lincom,r(estimate),SE,r(se),T,r(estimate)/r(se)) adec(3)
xi: ivreg2 _1 (inctax_wage_median inctax_inv_median_ma5=inctax_wage inctax_inv_ma5) gdp bills bonds equities i.ctyno i.taxyear, cl(ctyno) fwl(_I*) first 
lincom inctax_wage_median+inctax_inv_median_ma5
outreg using table_results.doc, coefastr se nocons 3aster append ct("") bdec(3) bracket addstat(Lincom,r(estimate),SE,r(se),T,r(estimate)/r(se)) adec(3)

* Wage tax rate & Investment tax regressions with 10 year MA (Table 7, Panel B)
xi: ivreg2 _1 (inctax_wage_median inctax_inv_median_ma10=inctax_wage inctax_inv_ma10) i.ctyno i.taxyear, cl(ctyno) fwl(_I*) first 
lincom inctax_wage_median+inctax_inv_median_ma10
outreg using table_results.doc, coefastr se nocons 3aster append ct("") bdec(3) bracket addstat(Lincom,r(estimate),SE,r(se),T,r(estimate)/r(se)) adec(3)
xi: ivreg2 _1 (inctax_wage_median inctax_inv_median_ma10=inctax_wage inctax_inv_ma10) gdp i.ctyno i.taxyear, cl(ctyno) fwl(_I*) first 
lincom inctax_wage_median+inctax_inv_median_ma10
outreg using table_results.doc, coefastr se nocons 3aster append ct("") bdec(3) bracket addstat(Lincom,r(estimate),SE,r(se),T,r(estimate)/r(se)) adec(3)
xi: ivreg2 _1 (inctax_wage_median inctax_inv_median_ma10=inctax_wage inctax_inv_ma10) gdp i.ctyno i.taxyear if cty~="nz", cl(ctyno) fwl(_I*) first 
lincom inctax_wage_median+inctax_inv_median_ma10
outreg using table_results.doc, coefastr se nocons 3aster append ct("No NZ") bdec(3) bracket addstat(Lincom,r(estimate),SE,r(se),T,r(estimate)/r(se)) adec(3)
xi: ivreg2 _1 (inctax_wage_median inctax_inv_median_ma10=inctax_wage inctax_inv_ma10) gdp bills bonds equities i.ctyno i.taxyear, cl(ctyno) fwl(_I*) first 
lincom inctax_wage_median+inctax_inv_median_ma10
outreg using table_results.doc, coefastr se nocons 3aster append ct("") bdec(3) bracket addstat(Lincom,r(estimate),SE,r(se),T,r(estimate)/r(se)) adec(3)

* Pre-1960 only
xi: ivreg2 _1 (inctax_wage_median=inctax_wage) gdp i.ctyno i.taxyear if taxyear<1960, cl(ctyno) fwl(_I*) 
xi: ivreg2 _1 (inctax_inv_median_ma5=inctax_inv_ma5) gdp i.ctyno i.taxyear if taxyear<1960, cl(ctyno) fwl(_I*) 

* Newey-West alternative
*xi: newey2 _1 (inctax_wage_median=inctax_wage) i.ctyno i.taxyear, lag(10) force

* How much can tax rates explain?
gen top1=exp(_1)
gen log1=_1
for any log1 top1 inctax_wage_median inctax_inv_median_ma5 inctax_inv_median_ma10 \ any log1 top1 wage inv5 inv10: gen temp1=X if taxyear==1970 \ bysort ctyno: egen temp2=max(temp1) \ gen dY=X-temp2 if taxyear==2000 \ drop temp*
bysort cty: sum d*
sum d*

* Revenue hill simulations
clear
set more off
set obs 101
gen taxrate=(_n-1)/100
* E=1.2
gen beta=1.2
gen k=0
gen revenue= taxrate*exp(k+beta*(1-taxrate)) 
egen temp1=max(revenue)
gen maxpoint=taxrate if temp1==revenue 
gen temp2=revenue if maxpoint==taxrate
egen maxrevenue=max(temp2)
gen revenue12=revenue/maxrevenue
* E=1.6
drop revenue temp* max*
replace beta=1.6
gen revenue= taxrate*exp(k+beta*(1-taxrate)) 
egen temp1=max(revenue)
gen maxpoint=taxrate if temp1==revenue 
gen temp2=revenue if maxpoint==taxrate
egen maxrevenue=max(temp2)
gen revenue16=revenue/maxrevenue
for num 12 16 \ num 1.2 1.6: la var revenueX "Elasticity = Y"
set scheme s1mono
tw line revenue12 revenue16 taxrate, xti("Tax rate on top percentile group") yti("Tax revenue from top percentile group" "(as a share of maximum revenue)") ti("Figure 9: Simulated Revenue Hills") ylab(0 "0%" .2 "20%" .4 "40%" .6 "60%" .8 "80%" 1 "100%") xlab(0 "0%" .2 "20%" .4 "40%" .6 "60%" .8 "80%" 1 "100%") ysc(r(0 1.1)) text(1 .63 "63%",place(n)) text(1 .83 "83%",place(n)) lpattern(solid dash) lcolor(black black)
